CREATE PROCEDURE spStudycharge
    @ModalityType varchar(18), 
    @StatStartDttm datetime,
    @StatEndDttm datetime 
AS
BEGIN
 
DECLARE @sStudycharge money
DECLARE @iStudy_key int
DECLARE @sBodyPart varchar(128)
DECLARE @iPos int
DECLARE @sBodyChild varchar(128)
DECLARE @iLen int


DECLARE crStudy CURSOR FOR

SELECT Study_key, study_charge, study_bodypart
FROM study
WHERE study_modalitytype=@ModalityType  AND report_state > 0 AND
	study_dttm >= @StatStartDttm AND study_dttm <= @StatEndDttm 

OPEN crStudy

FETCH NEXT FROM crStudy 
INTO @iStudy_key,@sStudycharge,@sBodyPart

WHILE @@FETCH_STATUS = 0
BEGIN
  SET @sBodyPart=RTRIM(LTRIM(@sBodyPart))  
  IF LEN(@sBodyPart) > 0
  BEGIN
	  SET @iPos=CHARINDEX(' ',@sBodyPart)          
	  WHILE @iPos>=1       
	  BEGIN    
		SET @sBodyChild=SUBSTRING(@sBodyPart,1,@iPos-1)  
		INSERT INTO CC_Statist (study_charge,tmp_BodyPart,BodyPart_Weight)  
			VALUES(@sStudycharge,@sBodyChild,1)  
		SET @iLen=LEN(@sBodyPart)  
		SET @sBodyPart=SUBSTRING(@sBodyPart,@iPos+1,@iLen)  
		SET @sBodyPart=RTRIM(LTRIM(@sBodyPart))  
		SET @iPos=CHARINDEX(' ',@sBodyPart)  
	  END

	  INSERT INTO CC_Statist (study_key,study_charge,tmp_BodyPart,BodyPart_Weight)    
		VALUES(@iStudy_key,@sStudycharge,@sBodyPart,1) 
  END
  	
  FETCH NEXT FROM crStudy 
  INTO @iStudy_key,@sStudycharge,@sBodyPart  
END 

CLOSE crStudy     
DEALLOCATE crStudy 

END