//---------------------------------------------------------------------------
// HISעⱾűѶ	
//---------------------------------------------------------------------------
// String _opacsconnection; Լ
// String _hisconnection; 	Լ
// String _modalitytype; 	Լ
// TADOQuery _qryHisCommon  ⲿѶĶ
//---------------------------------------------------------------------------
// ʵֺ
//---------------------------------------------------------------------------
// String GetDeptCode(String sDeptName);
// String GetUserID(String sDeptName, String sUserName);

// סԺշ
// String GetChargeType(String sPatientID, int iVisitID);
// String GetInsuranceType(String sPatientID, int iVisitID);
// bool PatsInHospital(String sPatientID);
// double CalcSpaceMoney(String sPatientID);
// int GetMaxVisitID(String sPatientID);
// int GetMaxItemNo(String sPatientID, int iVisitID);

// շ
// int GetOutpNewVisitNo();
// TDateTime GetOutpMaxVisitDate(String sPatientID);
// int GetOutpMaxVisitNo(String sPatientID);
// int GetOutpMaxItemNo(String sPatientID);
// double CalcOutpSpaceMoney(String sPatientID);

// double CalcExamCharge(double fExamCost, String sChargeType, String sInsuranceType, 
//		String sItemClass, String sItemCode, String sItemSpec);

// BILL_DETAIL
// double CalcTotalExamCharge(TADOQuery qryBillDetail);
// double CalcTotalExamCost(TADOQuery qryBillDetail);
// String CalcTotalExamItem(TADOQuery qryBillDetail);
//---------------------------------------------------------------------------

#include "..\\Common\\HisCommon.cpp"

String      _opacsconnection;
String      _hisconnection;
String 		_modalitytype;

//---------------------------------------------------------------------------
String GetDeptCode(String sDeptName)
{
    // ȡDEPT_CODE
    String sQuery = "SELECT DEPT_CODE FROM DEPT_DICT WHERE DEPT_NAME = '" + sDeptName + "'";
    _qryHisCommon.Close();
    _qryHisCommon.SQL.Text = sQuery;
    _qryHisCommon.Open();
    String sDeptID = "";
    if (!_qryHisCommon.IsEmpty())
        sDeptID = _qryHisCommon.FieldByName("DEPT_CODE").AsString;
        
    return sDeptID;
}
//---------------------------------------------------------------------------

String GetUserID(String sDeptName, String sUserName)
{
    // ȡUSER_ID
    String sQuery = "SELECT USER_ID FROM DEPT_DICT, USERS WHERE " + 
        "DEPT_DICT.DEPT_CODE = USERS.USER_DEPT AND DEPT_DICT.DEPT_NAME= '" +
        sDeptName + "' AND USERS.USER_NAME = '" + sUserName + "'";
    _qryHisCommon.Close();
    _qryHisCommon.SQL.Text = sQuery;
    _qryHisCommon.Open();
    String sUserID = "0000";
    if (!_qryHisCommon.IsEmpty())
        sUserID = _qryHisCommon.FieldByName("USER_ID").AsString;
        
    return sUserID;
}

//---------------------------------------------------------------------------
// סԺշ
//---------------------------------------------------------------------------
String GetChargeType(String sPatientID, int iVisitID)
{
    // ȡշ
    String sQuery = "SELECT CHARGE_TYPE FROM PAT_VISIT WHERE PATIENT_ID = '"
        + sPatientID + "' AND VISIT_ID = " + IntToStr(iVisitID);
    _qryHisCommon.Close();
    _qryHisCommon.SQL.Text = sQuery;
    _qryHisCommon.Open();
    String sChargeType = "";
    if (!_qryHisCommon.IsEmpty())
        sChargeType = _qryHisCommon.FieldByName("CHARGE_TYPE").AsString;

    return sChargeType;
}
//---------------------------------------------------------------------------

String GetInsuranceType(String sPatientID, int iVisitID)
{
    // ȡ
    String sQuery = "SELECT INSURANCE_TYPE FROM PAT_VISIT WHERE PATIENT_ID = '"
        + sPatientID + "' AND VISIT_ID = " + IntToStr(iVisitID);
    _qryHisCommon.Close();
    _qryHisCommon.SQL.Text = sQuery;
    _qryHisCommon.Open();
    String sInsuranceType = "";
    if (!_qryHisCommon.IsEmpty())
        sInsuranceType = _qryHisCommon.FieldByName("INSURANCE_TYPE").AsString;

    return sInsuranceType;
}
//---------------------------------------------------------------------------

bool PatsInHospital(String sPatientID)
{
    // ǷԺ
    String sQuery = "SELECT * FROM PATS_IN_HOSPITAL WHERE PATIENT_ID = '" +  sPatientID + "'";
    _qryHisCommon.Close();
    _qryHisCommon.SQL.Text = sQuery;
    _qryHisCommon.Open();
    bool bInHospital = false;
    if (!_qryHisCommon.IsEmpty())
        bInHospital = true;

    return bInHospital;
}
//---------------------------------------------------------------------------

double CalcSpaceMoney(String sPatientID)
{
    // ȡסԺԤ
    String sQuery = "SELECT PREPAYMENTS, TOTAL_CHARGES FROM PATS_IN_HOSPITAL "
        + "WHERE PATIENT_ID = '" + sPatientID + "'";
    _qryHisCommon.Close();
    _qryHisCommon.SQL.Text = sQuery;
    _qryHisCommon.Open();
    double fSpaceMoney = 0.0;
    if (!_qryHisCommon.IsEmpty())
        fSpaceMoney = _qryHisCommon.FieldByName("PREPAYMENTS").AsFloat -
            _qryHisCommon.FieldByName("TOTAL_CHARGES").AsFloat;

    return fSpaceMoney;
}
//---------------------------------------------------------------------------

int GetMaxVisitID(String sPatientID)
{
    // ȡסԺVISIT_ID
    String sQuery = "SELECT MAX(VISIT_ID) AS MaxVisitID FROM PAT_VISIT "
        + "WHERE PATIENT_ID = '" + sPatientID + "'";
    _qryHisCommon.Close();
    _qryHisCommon.SQL.Text = sQuery;
    _qryHisCommon.Open();
    int iMaxVisitID = 0;
    if (!_qryHisCommon.IsEmpty())
        iMaxVisitID = _qryHisCommon.FieldByName("MaxVisitID").AsInteger;
    if (iMaxVisitID == 0) // ԣ
        iMaxVisitID = 1;

    return iMaxVisitID;
}
//---------------------------------------------------------------------------

int GetMaxItemNo(String sPatientID, int iVisitID)
{
    // ȡסԺITEM_NO
    String sQuery = "SELECT MAX(ITEM_NO) AS MaxItemNo FROM INP_BILL_DETAIL "
        + "WHERE PATIENT_ID = '" + sPatientID + "' AND VISIT_ID = " + IntToStr(iVisitID);
    _qryHisCommon.Close();
    _qryHisCommon.SQL.Text = sQuery;
    _qryHisCommon.Open();
    int iMaxItemNo = 0;
    if (!_qryHisCommon.IsEmpty())
        iMaxItemNo = _qryHisCommon.FieldByName("MaxItemNo").AsInteger;
    
    return iMaxItemNo;
}

//---------------------------------------------------------------------------
// շ
//---------------------------------------------------------------------------
int GetOutpNewVisitNo()
{
    // ȡVISIT_NO
    String sQuery = "";
    if (IsConnetAccessDB(_hisconnection))
    {
	    sQuery = "SELECT (Max(VISIT_NO) + 1) AS NewVisitNo FROM CLINIC_MASTER " +
	    	"WHERE DateDiff('d', VISIT_DATE, Date()) = 0";
	}
	else
	{
		sQuery = "SELECT VISIT_NO.NEXTVAL AS NewVisitNo FROM DUAL";
	}
    _qryHisCommon.Close();
    _qryHisCommon.SQL.Text = sQuery;
    _qryHisCommon.Open();
    int iNewVisitNo = 0;
    if (!_qryHisCommon.IsEmpty())
        iNewVisitNo = _qryHisCommon.FieldByName("NewVisitNo").AsInteger;
    if (iNewVisitNo == 0) // ԣ
        iNewVisitNo = 1;

    return iNewVisitNo;
}
//---------------------------------------------------------------------------

TDateTime GetOutpMaxVisitDate(String sPatientID)
{
    // ȡVISIT_DATE
    String sQuery = "";
    if (IsConnetAccessDB(_hisconnection))
    {
	    sQuery = "SELECT Max(VISIT_DATE) AS MaxVisitDate FROM OUTP_ORDER_DESC " +
	    	"WHERE PATIENT_ID = '" + sPatientID + "'";
	}
	else
	{
		sQuery = "SELECT MAX(VISIT_DATE) AS MaxVisitDate FROM OUTP_ORDER_DESC " + 
	    	"WHERE PATIENT_ID = '" + sPatientID + "'";
	}
    _qryHisCommon.Close();
    _qryHisCommon.SQL.Text = sQuery;
    _qryHisCommon.Open();
    TDateTime dtMaxVisitDate = Now();
    if (!_qryHisCommon.IsEmpty())
        dtMaxVisitDate = _qryHisCommon.FieldByName("MaxVisitDate").AsDateTime;

    return dtMaxVisitDate;
}
//---------------------------------------------------------------------------

int GetOutpMaxVisitNo(String sPatientID)
{
    // ȡVISIT_NO
    String sQuery = "";
    if (IsConnetAccessDB(_hisconnection))
    {
	    sQuery = "SELECT TOP 1 VISIT_NO FROM OUTP_ORDER_DESC " +
	    	"WHERE PATIENT_ID = '" + sPatientID + "' ORDER BY VISIT_DATE DESC";
	}
	else
	{
		sQuery = "SELECT VISIT_NO FROM OUTP_ORDER_DESC " + 
	    	"WHERE PATIENT_ID = '" + sPatientID + "' and ROWNUM<=1 ORDER BY VISIT_DATE DESC";
	}
    _qryHisCommon.Close();
    _qryHisCommon.SQL.Text = sQuery;
    _qryHisCommon.Open();
    int iMaxVisitNo = 0;
    if (!_qryHisCommon.IsEmpty())
        iMaxVisitNo = _qryHisCommon.FieldByName("VISIT_NO").AsInteger;

    return iMaxVisitNo;
}
//---------------------------------------------------------------------------

int GetOutpMaxItemNo(String sPatientID)
{
    // ȡITEM_NO
    String sQuery = "";
    if (IsConnetAccessDB(_hisconnection))
    {
    	sQuery = "SELECT TOP 1 ITEM_NO FROM OUTP_BILL_ITEMS a, OUTP_ORDER_DESC b " + 
	    	"WHERE VISIT_DATE = b.VISIT_DATE and a.VISIT_NO = b.VISIT_NO and " + 
	    	"PATIENT_ID = '" + sPatientID + "' ORDER BY a.VISIT_DATE DESC, ITEM_NO DESC";
    }
	else
	{
		sQuery = "SELECT a.ITEM_NO FROM OUTP_BILL_ITEMS a, OUTP_ORDER_DESC b " + 
	    	"WHERE a.VISIT_DATE = b.VISIT_DATE and a.VISIT_NO = b.VISIT_NO and " + 
	    	"PATIENT_ID = '" + sPatientID + "' and ROWNUM<=1 ORDER BY a.VISIT_DATE DESC, ITEM_NO DESC";
	}   
    _qryHisCommon.Close();
    _qryHisCommon.SQL.Text = sQuery;
    _qryHisCommon.Open();
    int iMaxItemNo = 0;
    if (!_qryHisCommon.IsEmpty())
        iMaxItemNo = _qryHisCommon.FieldByName("ITEM_NO").AsInteger;
    
    return iMaxItemNo;
}
//---------------------------------------------------------------------------

double CalcOutpSpaceMoney(String sPatientID)
{
    // ȡԤ
    String sQuery = "SELECT SUM(A.AMOUNT) AS SUM_PREPAY, SUM(C.CHARGES) AS SUM_CHARGES "
    	+ "FROM OUTP_PREPAY_RCPT a, OUTP_ORDER_DESC b, OUTP_BILL_ITEMS c " 
		+ "WHERE a.PATIENT_ID = b.PATIENT_ID AND a.TRANSACT_TYPE <> '' "
		+ "AND b.VISIT_DATE = c.VISIT_DATE AND b.VISIT_NO = c.VISIT_NO AND b.RCPT_NO IS NULL "
		+ "AND a.PATIENT_ID = '" + sPatientID + "'";
    _qryHisCommon.Close();
    _qryHisCommon.SQL.Text = sQuery;
    _qryHisCommon.Open();
    double fSpaceMoney = 0.0;
    if (!_qryHisCommon.IsEmpty())
        fSpaceMoney = _qryHisCommon.FieldByName("SUM_PREPAY").AsFloat -
            _qryHisCommon.FieldByName("SUM_CHARGES").AsFloat;

    return fSpaceMoney;
}
//---------------------------------------------------------------------------

double CalcExamCharge(double fExamCost, String sChargeType, String sInsuranceType, 
	String sItemClass, String sItemCode, String sItemSpec)
{
    // ʵӦ
    String sQuery = "";
    double fExamCharge = fExamCost; // Ĭ
    double f1 = 0.0;
    double f2 = 0.0;
    ////
    int iChargePriceIndicator = 0;
    if (sChargeType == "ҽ") // ҽ
    {
        //1.9	ѱֵ CHARGE_TYPE_DICT
        sQuery = "SELECT CHARGE_PRICE_INDICATOR FROM CHARGE_TYPE_DICT "
            + "WHERE CHARGE_TYPE_NAME = '" + sChargeType + "'";
        _qryHisCommon.Close();
        _qryHisCommon.SQL.Text = sQuery;
        _qryHisCommon.Open();
        if (!_qryHisCommon.IsEmpty())
        {
            iChargePriceIndicator = _qryHisCommon.FieldByName("CHARGE_PRICE_INDICATOR").Value;
        }
        ////
        if (iChargePriceIndicator != 0) // շĿ
        {
            //20.11	ҽƱҽĿųֵ PAY_SPECIAL_EXCEPT_DICT
            sQuery = "SELECT PROPORTION_NUMERATOR, PROPORTION_DENOMINATOR, REIMBURSE_LIMIT "
                + "FROM PAY_SPECIAL_EXCEPT_DICT WHERE INSURANCE_TYPE = '" + sInsuranceType
                + "' AND ITEM_CLASS = '" + sItemClass + "' AND ITEM_CODE = '" + sItemCode
                + "' AND ITEM_SPEC = '" + sItemSpec + "'";
            _qryHisCommon.Close();
            _qryHisCommon.SQL.Text = sQuery;
            _qryHisCommon.Open();
            if (!_qryHisCommon.IsEmpty())
            {
                if (_qryHisCommon.FieldByName("REIMBURSE_LIMIT").IsNull)
                {
                    f1 = _qryHisCommon.FieldByName("PROPORTION_NUMERATOR").AsFloat;
                    f2 = _qryHisCommon.FieldByName("PROPORTION_DENOMINATOR").AsFloat;
                    fExamCharge = fExamCost * f1 / f2;
                }
                else
                {
                    fExamCharge = fExamCost - _qryHisCommon.FieldByName("REIMBURSE_LIMIT").AsFloat;
                }
                return fExamCharge;
            }
            ////
            //20.10	ҽƱҽĿֵ PAY_SPECIAL_ITEM_DICT
            sQuery = "SELECT PROPORTION_NUMERATOR, PROPORTION_DENOMINATOR, REIMBURSE_LIMIT "
                + "FROM PAY_SPECIAL_ITEM_DICT WHERE INSURANCE_TYPE = '" + sInsuranceType
                + "' AND ITEM_CLASS = '" + sItemClass + "' AND ITEM_CODE = '" + sItemCode
                + "' AND ITEM_SPEC = '" + sItemSpec + "'";
            _qryHisCommon.Close();
            _qryHisCommon.SQL.Text = sQuery;
            _qryHisCommon.Open();
            if (!_qryHisCommon.IsEmpty())
            {
                if (_qryHisCommon.FieldByName("REIMBURSE_LIMIT").IsNull)
                {
                    f1 = _qryHisCommon.FieldByName("PROPORTION_NUMERATOR").AsFloat;
                    f2 = _qryHisCommon.FieldByName("PROPORTION_DENOMINATOR").AsFloat;
                    fExamCharge = fExamCost * f1 / f2;
                }
                else
                {
                    fExamCharge = fExamCost - _qryHisCommon.FieldByName("REIMBURSE_LIMIT").AsFloat;
                }
                return fExamCharge;
            }
        }
        ////
        //20.9	סԺҽƱ֧ PAY_SCHEMA_FOR_INP
        sQuery = "SELECT PROPORTION_NUMERATOR, PROPORTION_DENOMINATOR "
            + "FROM PAY_SCHEMA_FOR_INP WHERE INSURANCE_TYPE = '" + sInsuranceType
            + "' AND LOW_LEVEL < " + FloatToStr(fExamCharge) + " AND (UPPER_LEVEL >= "
            + FloatToStr(fExamCost) + " OR UPPER_LEVEL = -1)";
        _qryHisCommon.Close();
        _qryHisCommon.SQL.Text = sQuery;
        _qryHisCommon.Open();
        if (!_qryHisCommon.IsEmpty())
        {
            f1 = _qryHisCommon.FieldByName("PROPORTION_NUMERATOR").AsFloat;
            f2 = _qryHisCommon.FieldByName("PROPORTION_DENOMINATOR").AsFloat;
            fExamCharge = fExamCost * f1 / f2;
            return fExamCharge;
        }
        ////
        return fExamCharge;
    }
    else // Ǿҽ
    {
        //1.9	ѱֵ CHARGE_TYPE_DICT
        sQuery = "SELECT CHARGE_PRICE_INDICATOR FROM CHARGE_TYPE_DICT "
            + "WHERE CHARGE_TYPE_NAME = '" + sChargeType + "'";
        _qryHisCommon.Close();
        _qryHisCommon.SQL.Text = sQuery;
        _qryHisCommon.Open();
        if (!_qryHisCommon.IsEmpty())
        {
            iChargePriceIndicator = _qryHisCommon.FieldByName("CHARGE_PRICE_INDICATOR").Value;
        }
        ////
        if (iChargePriceIndicator != 0) // շĿ
        {
            //6.19	շĿųֵ CHARGE_SPECIAL_EXCEPT_DICT
            sQuery = "SELECT PROPORTION_NUMERATOR, PROPORTION_DENOMINATOR, FREE_LIMIT "
                + "FROM CHARGE_SPECIAL_EXCEPT_DICT WHERE CHARGE_TYPE = '" + sChargeType
                + "' AND ITEM_CLASS = '" + sItemClass + "' AND ITEM_CODE = '" + sItemCode
                + "' AND ITEM_SPEC = '" + sItemSpec + "'";
            _qryHisCommon.Close();
            _qryHisCommon.SQL.Text = sQuery;
            _qryHisCommon.Open();
            if (!_qryHisCommon.IsEmpty())
            {
                if (_qryHisCommon.FieldByName("FREE_LIMIT").IsNull)
                {
                    f1 = _qryHisCommon.FieldByName("PROPORTION_NUMERATOR").AsFloat;
                    f2 = _qryHisCommon.FieldByName("PROPORTION_DENOMINATOR").AsFloat;
                    fExamCharge = fExamCost * f1 / f2;
                }
                else
                {
                    fExamCharge = fExamCost - _qryHisCommon.FieldByName("FREE_LIMIT").AsFloat;
                }
                return fExamCharge;
            }
            ////
            //6.18	շĿֵ CHARGE_SPECIAL_ITEM_DICT
            sQuery = "SELECT PROPORTION_NUMERATOR, PROPORTION_DENOMINATOR, FREE_LIMIT "
                + "FROM CHARGE_SPECIAL_ITEM_DICT WHERE CHARGE_TYPE = '" + sChargeType
                + "' AND ITEM_CLASS = '" + sItemClass + "' AND ITEM_CODE = '" + sItemCode
                + "' AND ITEM_SPEC = '" + sItemSpec + "'";
            _qryHisCommon.Close();
            _qryHisCommon.SQL.Text = sQuery;
            _qryHisCommon.Open();
            if (!_qryHisCommon.IsEmpty())
            {
                if (_qryHisCommon.FieldByName("FREE_LIMIT").IsNull)
                {
                    f1 = _qryHisCommon.FieldByName("PROPORTION_NUMERATOR").AsFloat;
                    f2 = _qryHisCommon.FieldByName("PROPORTION_DENOMINATOR").AsFloat;
                    fExamCharge = fExamCost * f1 / f2;
                }
                else
                {
                    fExamCharge = fExamCost - _qryHisCommon.FieldByName("FREE_LIMIT").AsFloat;
                }
                return fExamCharge;
            }
        }
        ////
        //6.4	շϵֵ CHARGE_PRICE_SCHEDULE
        sQuery = "SELECT PRICE_COEFF_NUMERATOR, PRICE_COEFF_DENOMINATOR "
            + "FROM CHARGE_PRICE_SCHEDULE WHERE CHARGE_TYPE = '" + sChargeType + "'";
        _qryHisCommon.Close();
        _qryHisCommon.SQL.Text = sQuery;
        _qryHisCommon.Open();
        if (!_qryHisCommon.IsEmpty())
        {
            f1 = _qryHisCommon.FieldByName("PRICE_COEFF_NUMERATOR").AsFloat;
            f2 = _qryHisCommon.FieldByName("PRICE_COEFF_DENOMINATOR").AsFloat;
            fExamCharge = fExamCost * f1 / f2;
            return fExamCharge;
        }
    }

    return fExamCharge;
}

//---------------------------------------------------------------------------
// BILL_DETAIL
//---------------------------------------------------------------------------
double CalcTotalExamCharge(TADOQuery qryBillDetail)
{
	// ȡϸмĿӦ
	double fExamCharge = 0.0;
    for (int i = 0; i < GetRecordCount(qryBillDetail); i++)
    {
    	SetRecNo(qryBillDetail, i+1);
        fExamCharge += qryBillDetail.FieldByName("bill_examcharge").AsFloat;
    }
    return fExamCharge;
} 
//---------------------------------------------------------------------------

double CalcTotalExamCost(TADOQuery qryBillDetail)
{
	// ȡϸмĿӦ
	double fExamCost = 0.0;
    for (int i = 0; i < GetRecordCount(qryBillDetail); i++)
    {
    	SetRecNo(qryBillDetail, i+1);
        fExamCost += qryBillDetail.FieldByName("bill_examcost").AsFloat;
    }
    return fExamCost;
} 
//---------------------------------------------------------------------------

String CalcTotalExamItem(TADOQuery qryBillDetail)
{
	// ȡϸмĿӦ
	String sExamItem = "";
    for (int i = 0; i < GetRecordCount(qryBillDetail); i++)
    {
    	SetRecNo(qryBillDetail, i+1);
        sExamItem = sExamItem +  " "  + qryBillDetail.FieldByName("bill_examname").AsString;
    }
    return Trim(sExamItem);
} 
//---------------------------------------------------------------------------

// 
{
    // Nothing need to do.
}
//---------------------------------------------------------------------------
